cronjobs.controllers.module('miscellaneous',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-cronjobs-miscellaneous',
            template: '#cronjobs-miscellaneous',
            parent: 'gx-cronjobs-overview',
            props: {
                meta: {
                    required: true,
                    type: Object
                }
            },
            data: () => {
                return {
                    lang: {
                        status_active: jse.core.lang.translate('status_active', 'cronjobs'),
                        sub_title_miscellaneous: jse.core.lang.translate('sub_title_miscellaneous', 'cronjobs'),
                        last_executed: jse.core.lang.translate('last_executed', 'cronjobs'),
                        status_inactive: jse.core.lang.translate('status_inactive', 'cronjobs'),
                        miscellaneous_cronjob_error: jse.core.lang.translate('miscellaneous_cronjob_error', 'cronjobs'),
                        copy_to_clipboard: jse.core.lang.translate('copy_to_clipboard', 'cronjobs'),
                        cronjob_setup_description: jse.core.lang.translate('cronjob_setup_description', 'cronjobs'),
                    }
                }
            },
            methods: {
                copyUrl() {
                    let cronUrlField = $('#cron-url');
                    cronUrlField.focus();
                    cronUrlField.select();
                    document.execCommand('copy');

                    // Add success message to admin info box.
                    const message = jse.core.lang.translate('copy_success', 'cronjobs');
                    jse.libs.info_box.addSuccessMessage(message);
                }
            },
            mounted() {
                const $container = $('.element-container');

                gx.extensions.init($container);
                gx.widgets.init($container);
            },
            init: done => done()
        }
    });